#include "helpers/calculations.h"

#include <cmath>

namespace gtfsplanner {

double calculate_distance(double lon1, double lat1, double lon2, double lat2)
{
    const double deg2rad = 3.141592653589793238462643383279502884 / 180.0;
    lat1 *= deg2rad;
    lon1 *= deg2rad;
    lat2 *= deg2rad;
    lon2 *= deg2rad;

    // Haversine Formula
    double dlon = lon2 - lon1;
    double dlat = lat2 - lat1;

    double ans = pow(sin(dlat / 2.0), 2) + cos(lat1) * cos(lat2) * pow(sin(dlon / 2.0), 2);
    ans = 2 * asin(sqrt(ans));
    return ans * 6371000; // assumed radius of the Earth in m
}

} // namespace gtfsplanner
