#include "commands/help.h"

#include "commands/parser.h"
#include "helpers/console.h"

#include <sstream>

namespace gtfsplanner {
static const std::vector<std::string> commands = {"arrival",  "count", "departure", "exit",
                                                  "info",     "help",  "list",      "load",
                                                  "mapcount", "route", "trip"};

Help_cmd::Help_cmd(std::vector<std::string> const& parameters) : Command(parameters) {}

void Help_cmd::sanitize()
{
    auto const& params = get_parameters();
    if (!params.empty())
    {
        check_for_unknown_params(params, commands, "help");
        m_command = build_command(params[0], std::vector<std::string>());
    }
}

void Help_cmd::execute(gtfs::Dataset& /*dataset*/)
{
    if (!m_command)
    {
        Console::write("gtfsplanner allows parsing gtfs datasets, to query various infos on the "
                       "data and to calculate routes on the data.\n");
        Console::write(
            "Usage: The program is command driven. Commands can either be provided on the built-in console or by providing a \
config file that contains a list of commands to be executed. The command syntax is simply <command> <command_parameters>, where the parameters depend on the command.\n");
        Console::write("The following commands are supported: " + cmds_to_string(commands) + "\n");
        Console::write(
            "In order to get additional information on the commands, type help <command>\n");
    }
    else
    {
        m_command->help();
    }
}

void Help_cmd::help()
{
    Console::write("Usage: help <command>\n");
    Console::write("Provides a help message for the given command.\n");
}
} // namespace gtfsplanner
