#include "commands/exit.h"

#include "helpers/console.h"

namespace gtfsplanner {
static bool exit_has_been_called = false;

Exit_cmd::Exit_cmd(std::vector<std::string> const& parameters) : Command(parameters) {}

Exit_cmd::~Exit_cmd()
{
    if (m_set_exit_called)
    {
        exit_has_been_called = true;
    }
}

void Exit_cmd::sanitize() {}

void Exit_cmd::execute(gtfs::Dataset& dataset) {}

void Exit_cmd::help()
{
    m_set_exit_called = false;
    Console::write("Usage: exit\n");
    Console::write("Exits the program.\n");
}

bool exit_called() noexcept
{
    return exit_has_been_called;
}
} // namespace gtfsplanner
