#ifndef GTFSPLANNER_PROGRESSWRITER_H
#define GTFSPLANNER_PROGRESSWRITER_H

#include <chrono>
#include <string>

namespace gtfsplanner {
/// writes a progress "bar" as line on stdout
class Progress_writer
{
public:
    Progress_writer(std::string const& title, std::streamoff total);
    ~Progress_writer();

    void update(std::streamoff current);

    std::string get_elapsed_time();

private:
    std::streamoff m_total;
    std::streamoff m_current;
    std::streamoff m_current_percentage;
    std::chrono::time_point<std::chrono::steady_clock> m_start;
};
} // namespace gtfsplanner

#endif
