#ifndef GTFSPLANNER_HEATMAP_H
#define GTFSPLANNER_HEATMAP_H

#include <cstdint>
#include <vector>

namespace gtfsplanner {
class Heatmap
{
public:
    enum class Gradient
    {
        Rainbow,
        Monochrome,
        Viridis,
        Inferno,
        Wistia
    };

    struct Color
    {
        uint8_t r;
        uint8_t g;
        uint8_t b;
    };

    Heatmap(Gradient type = Gradient::Rainbow);
    void set_gradient(Gradient type);

    Color get_color(double value);

private:
    std::vector<Color> m_colors;
};
} // namespace gtfsplanner

#endif
