#ifndef GTFSPLANNER_EXCEPTION_H
#define GTFSPLANNER_EXCEPTION_H

#include <stdexcept>

namespace gtfsplanner {
class Exception : public std::runtime_error
{
public:
    Exception(std::string const& msg) : std::runtime_error(msg) {}
};

class Parse_error : public Exception
{
public:
    Parse_error(std::string const& msg) : Exception("Argument parsing error: " + msg) {}
};

class Command_error : public Exception
{
public:
    Command_error() : Exception("Cannot execute invalid command.") {}
};

class Data_error : public Exception
{
public:
    Data_error(std::string const& msg) : Exception("Data error: " + msg) {}
};

class File_error : public Exception
{
public:
    File_error(std::string const& msg) : Exception("File_error: " + msg) {}
};
} // namespace gtfsplanner

#endif
