#ifndef GTFSPLANNER_CONSOLE_H
#define GTFSPLANNER_CONSOLE_H

#include <string>

namespace gtfsplanner {
// \brief abstraction of the stdout console as it works differently on Linux and Windows concerning UTF8
class Console
{
public:
    static void write(std::string const& out);

    /// read a string from the console
    static std::string read();

    static Console& get();

    static bool eof();
    static void flush();

    /// indent each line by count spaces
    void set_indent(size_t count) { m_indent = count; }

    void write_impl(std::string const& out);
    std::string read_impl();
    bool eof_impl();
    void flush_impl();

private:
    Console() = default;
    size_t m_indent = 0;
};
} // namespace gtfsplanner

#endif
