#ifndef GTFSPLANNER_GTFSHELPERS_H
#define GTFSPLANNER_GTFSHELPERS_H

#include "gtfs_types.h"

namespace gtfsplanner {
struct Trip_stop
{
    std::string stop_id;
    std::string name;
    Time arrival;
    Time departure;
};

// contains departure/arrival information for a specific trip
struct Trip_data
{
    std::string trip_id;        // id of the trip
    std::string trip_type_name; // name of the trip, e.g. ICE 0815
    // stops on the trip
    std::vector<Trip_stop> stops;

    // calendar info, containing the info on which days the service is active
    // e.g. daily between start and end date
    // e.g. mo-fr between start and end date
    // e.g. every Sunday between start and end date
    gtfs::Calendar service_calendar;
    // extra exceptions for travel days
    // e.g. only on May 1st
    // e.g. in conjunction with calendar daily, except May 1st
    std::vector<gtfs::Calendar_date> service_exceptions;
};

Trip_data build_trip_data(gtfs::Dataset const& dataset, std::string const& trip_id);

// build the route name for the given trip, e.g. ICE 427
std::string build_route_name(gtfs::Dataset const& dataset, gtfs::Trip const& trip);

enum class Trip_mode
{
    DEPARTURE,
    ARRIVAL
};
void print(Trip_data const& trip, Trip_mode mode);
void print_trip_stops(Trip_data const& trip, Trip_mode mode);
void print_trip_service_days(Trip_data const& trip);

std::vector<gtfs::Stop>::const_iterator find_station(gtfs::Dataset const& dataset,
                                                     std::string const& station);
bool is_active_on_date(gtfs::Calendar const& calendar,
                       std::vector<gtfs::Calendar_date> const& exceptions,
                       Date const& date);
bool is_active_on_date(gtfs::Dataset const& dataset,
                       std::string const& service_id,
                       Date const& date);
bool fits_time_window(Time stop_time, Time const& start, Time const& end);

std::vector<Trip_data> get_departures(gtfs::Dataset const& dataset,
                                      std::string const& station_id,
                                      Date const& date,
                                      Time const& start,
                                      Time const& end);
std::vector<Trip_data> get_arrivals(gtfs::Dataset const& dataset,
                                    std::string const& station_id,
                                    Date const& date,
                                    Time const& start,
                                    Time const& end);

} // namespace gtfsplanner

#endif
