#ifndef GTFSPLANNER_COMMAND_ROUTE_H
#define GTFSPLANNER_COMMAND_ROUTE_H

#include "commands/command.h"
#include "types.h"
#include <memory>
#include <deque>
#include <unordered_set>
#include <unordered_map>

namespace gtfsplanner
{
	struct Travel_route;

	class Route_cmd : public Command
	{
	public:
		Route_cmd(std::vector<std::string> const& parameters);

		/// execute the command with the stored parameters
		/// \param dataset the dataset on which to operate, may be changed (e.g. load something, create an index, ...)
		virtual void execute(gtfs::Dataset& dataset) override;

		/// sanitize check of given parameters for the command
		/// throws std::runtime error if parameters are inconsistent/wrong
		virtual void sanitize() override;

		/// display a help message for this command
		virtual void help() override;
	private:
		std::string m_from;
		std::string m_to;
		Date m_date;
		Time m_start{ 0,0,0 };
		Time m_end{ 24,0,0 };
		Time m_total_time{ 24,0,0 };
		Time m_max_transfer_time{ 1,0,0 };
		Time m_min_transfer_time{ 0,10,0 };
		size_t m_max_transfers{ 10 };
		std::string m_map;
		std::string m_mapmode = "kml";
		std::string m_heatmode = "rainbow";
		bool m_backwards_search = false; // triggered by either providing no from stop or by providing only end time

		void add_transfers_to_queue(std::deque<Travel_route>& route_queue, Travel_route const& current_route,
			std::unordered_set<std::string> const& visited,
			std::unordered_map<std::string, std::vector<Travel_route>>& best_routes,
			gtfs::Dataset const& dataset);
	};
}

#endif
