#ifndef GTFSPLANNER_COMMAND_INFO_H
#define GTFSPLANNER_COMMAND_INFO_H

#include "commands/command.h"
#include <memory>

namespace gtfsplanner
{
	class Info_cmd : public Command
	{
	public:
		Info_cmd(std::vector<std::string> const& parameters);

		/// execute the command with the stored parameters
		/// \param dataset the dataset on which to operate, may be changed (e.g. load something, create an index, ...)
		virtual void execute(gtfs::Dataset& dataset) override;

		/// sanitize check of given parameters for the command
		/// throws std::runtime error if parameters are inconsistent/wrong
		virtual void sanitize() override;

		/// display a help message for this command
		virtual void help() override;
	};
}

#endif
