#ifndef GTFSPLANNER_COMMAND_EXIT_H
#define GTFSPLANNER_COMMAND_EXIT_H

#include "commands/command.h"

#include <string>
#include <vector>

namespace gtfsplanner
{
	class Exit_cmd : public Command
	{
	public:
		Exit_cmd(std::vector<std::string> const& parameters);
		~Exit_cmd();

		/// execute the command with the stored parameters
		/// \param dataset the dataset on which to operate, may be changed (e.g. load something, create an index, ...)
		virtual void execute(gtfs::Dataset& dataset) override;

		/// sanitize check of given parameters for the command
		/// throws std::runtime error if parameters are inconsistent/wrong
		virtual void sanitize() override;

		/// display a help message for this command
		virtual void help() override;
	private:
		bool m_set_exit_called = true;
	};

	bool exit_called() noexcept;
}

#endif
