#ifndef GTFSPLANNER_COMMAND_H
#define GTFSPLANNER_COMMAND_H

#include "helpers/console.h"
#include "helpers/exception.h"
#include <string>
#include <vector>

namespace gtfsplanner
{
	namespace gtfs
	{
		struct Dataset;
	}

	enum class Commands
	{
		ARRIVAL, // show arrivals at a stop
		COUNT, // count number of trips between two stations
		DEPARTURE, // show departures at a stop
		EXIT, // exit program
		INFO, // general info on the dataset
		LIST, // list trips and stations incl. filtering
		LOAD, // load dataset
		HELP, // display help
		MAPCOUNT, // create a line map counting connections between stops
		ROUTE,// calculate routes between stops
		TRIP, // show one trip
	};

	class Command
	{
	public:
		virtual ~Command() noexcept = default;
		Command(std::vector<std::string> const& parameters) : m_parameters(parameters) {}

		/// execute the command with the stored parameters
		/// \param dataset the dataset on which to operate, may be changed (e.g. load something, create an index, ...)
		virtual void execute(gtfs::Dataset& dataset) = 0;

		/// sanitize check of given parameters for the command
		/// throws std::runtime error if parameters are inconsistent/wrong
		virtual void sanitize() = 0;

		/// display a help message for this command
		virtual void help() = 0;

		std::vector<std::string> const& get_parameters() const noexcept
		{
			return m_parameters;
		}

	private:
		std::vector<std::string> m_parameters;
	
	};
}

#endif
