#ifndef GTFSPLANNER_COMMAND_ARRIVAL_H
#define GTFSPLANNER_COMMAND_ARRIVAL_H

#include "commands/command.h"
#include "types.h"
#include <memory>

namespace gtfsplanner
{
	class Arrival_cmd : public Command
	{
	public:
		Arrival_cmd(std::vector<std::string> const& parameters);

		/// execute the command with the stored parameters
		/// \param dataset the dataset on which to operate, may be changed (e.g. load something, create an index, ...)
		virtual void execute(gtfs::Dataset& dataset) override;

		/// sanitize check of given parameters for the command
		/// throws std::runtime error if parameters are inconsistent/wrong
		virtual void sanitize() override;

		/// display a help message for this command
		virtual void help() override;
	private:
		std::string m_stop;
		Time m_start{ 0,0,0 };
		Time m_end{ 24,0,0 };
		Date m_date{ 0,0,0 };
		std::string m_map;
		std::string m_mapmode = "kml";
		std::string m_heatmode = "rainbow";
	};
}

#endif
